package gov.va.genisis2.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.io.ClassPathResource;

@EnableCaching
@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class EhcacheConfiguration {

	private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheConfiguration.class);

	/**
	 * This method is used to get cacheManager.
	 * 
	 * @return This returns CacheManager.
	 */
	@Bean
	public CacheManager cacheManager() {

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("#========== CacheManager ==========#");
		}

		return new EhCacheCacheManager(cacheManagerFactory().getObject());
	}

	/**
	 * This method is used to get cacheManagerFactory bean.
	 * 
	 * @return This returns EhCacheManagerFactoryBean.
	 */
	@Bean
	public EhCacheManagerFactoryBean cacheManagerFactory() {

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("#========== cacheManagerFactory ==========#");
		}

		EhCacheManagerFactoryBean bean = new EhCacheManagerFactoryBean();
		bean.setConfigLocation(new ClassPathResource("ehcache.xml"));
		bean.setShared(true);
		return bean;
	}
}